/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileSystemUtils {
    private static final Log LOG = LogFactory.getLog(FileSystemUtils.class);
    private static final String TEST_OUTPUT_DIR = "../target/testoutput";
    private static final String TEST_INPUT_DIR = "../src/test/resources";

    private FileSystemUtils() {
    }

    public static void deleteDirRecursively(String aDir) {
        FileSystemUtils.deleteDirRecursively(new File(aDir));
    }

    public static void deleteDirRecursively(File aDir) {
        TestCase.assertTrue((boolean)aDir.isDirectory());
        for (File file : aDir.listFiles()) {
            if (file.isDirectory()) {
                FileSystemUtils.deleteDirRecursively(file);
                continue;
            }
            FileSystemUtils.delete(file);
        }
        FileSystemUtils.delete(aDir);
    }

    public static void delete(File aFile) {
        TestCase.assertTrue((boolean)aFile.delete());
    }

    public static File getPath(String aRelativePath, Class aTestClass) {
        CodeSource source = aTestClass.getProtectionDomain().getCodeSource();
        if (source == null) {
            LOG.warn((Object)("Could not obtain path for '" + aRelativePath + "' for class " + aTestClass + ", using relative path as is"));
            return new File(aRelativePath);
        }
        URL location = source.getLocation();
        String protocol = location.getProtocol();
        if (!protocol.equals("file")) {
            LOG.warn((Object)("protocol is not 'file': " + location));
            return new File(aRelativePath);
        }
        String path = location.getPath();
        try {
            path = URLDecoder.decode(location.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Decoding path failed: '" + location.getPath() + "'"), (Throwable)e);
        }
        return new File(new File(path).getParentFile(), aRelativePath);
    }

    public static void createDir(File aDir) {
        if (aDir.exists() && !aDir.isDirectory()) {
            TestCase.fail((String)("'" + aDir + "' already exists and is not a directory"));
        }
        if (aDir.exists()) {
            return;
        }
        FileSystemUtils.createDir(aDir.getParentFile());
        TestCase.assertTrue((String)("Could not create '" + aDir + "'"), (boolean)aDir.mkdir());
    }

    public static void createFile(File aDir, String aName, InputStream aContents) {
        FileSystemUtils.createDir(aDir);
        try {
            FileOutputStream os = new FileOutputStream(new File(aDir, aName));
            FileSystemUtils.copyStream(aContents, os);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public static File getTestOutputDir(Class aTestClass) {
        File file = FileSystemUtils.getPath(TEST_OUTPUT_DIR, aTestClass);
        String className = aTestClass.getName();
        String classRelPath = className.replaceAll("\\.", "/");
        return new File(file, classRelPath);
    }

    public static File getTestInputDir(Class aTestClass) {
        File file = FileSystemUtils.getPath(TEST_INPUT_DIR, aTestClass);
        String packageName = aTestClass.getPackage().getName();
        String packagePath = packageName.replaceAll("\\.", "/");
        return new File(file, packagePath);
    }

    public static File createTestOutputDir(Class aTestClass) {
        File file = FileSystemUtils.getTestOutputDir(aTestClass);
        FileSystemUtils.createDir(file);
        return file;
    }

    public static File getTestOutputFile(String aName, Class aTestClass) {
        File file = new File(FileSystemUtils.getTestOutputDir(aTestClass), aName);
        FileSystemUtils.createDir(file.getParentFile());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream aIs) throws IOException {
        try {
            int c;
            StringBuffer buffer = new StringBuffer();
            while ((c = aIs.read()) != -1) {
                buffer.append((char)c);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            aIs.close();
        }
    }

    public static void copyStream(InputStream aIs, OutputStream aOs) {
        try {
            int c;
            while ((c = aIs.read()) != -1) {
                aOs.write(c);
            }
            aIs.close();
            aOs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static void copyDir(File aSrc, File aTarget) {
        Assert.assertTrue((boolean)aSrc.isDirectory());
        Assert.assertTrue((!aTarget.exists() ? 1 : 0) != 0);
        aTarget.mkdirs();
        File[] files = aSrc.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (file.getName().equals(".svn")) continue;
                FileSystemUtils.copyDir(new File(aSrc, file.getName()), new File(aTarget, file.getName()));
                continue;
            }
            FileSystemUtils.copyFile(file, new File(aTarget, file.getName()));
        }
    }

    public static void copyFile(File aSrc, File aTarget) {
        try {
            FileInputStream fis = new FileInputStream(aSrc);
            FileOutputStream fos = new FileOutputStream(aTarget);
            FileChannel fcin = fis.getChannel();
            FileChannel fcout = fos.getChannel();
            MappedByteBuffer mbb = fcin.map(FileChannel.MapMode.READ_ONLY, 0L, fcin.size());
            fcout.write(mbb);
            fcin.close();
            fcout.close();
            fis.close();
            fos.close();
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Copying file " + aSrc.getPath() + " to " + aTarget.getPath() + " failed."), (boolean)false);
        }
    }

    public static void deleteDir(File aDir) {
        FileSystemUtils.cleanDir(aDir);
        FileSystemUtils.delete(aDir);
    }

    public static void cleanDir(File aDir) {
        if (!aDir.exists()) {
            return;
        }
        File[] entries = aDir.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            File file = entries[i];
            if (!file.isFile()) continue;
            Assert.assertTrue((String)("Could not delete " + entries[i].getPath()), (boolean)entries[i].delete());
        }
    }
}

