/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventTracker<Event> {
    private static final Log LOG = LogFactory.getLog(EventTracker.class);
    private Map<Thread, List<Event>> _events;

    public EventTracker() {
        this.clear();
    }

    public void clear() {
        this._events = new HashMap<Thread, List<Event>>();
    }

    public synchronized void eventOccurred(Event aEvent) {
        LOG.info((Object)("Event '" + aEvent + "' sent."));
        Thread current = Thread.currentThread();
        List<Event> events = this._events.get(current);
        if (events == null) {
            events = new ArrayList<Event>();
            this._events.put(current, events);
        }
        events.add(aEvent);
    }

    public synchronized boolean isEventSent(Thread aThread, Event aEvent) {
        List<Event> events = this._events.get(aThread);
        if (events == null) {
            return false;
        }
        return events.contains(aEvent);
    }

    public synchronized List<Event> getEvents(Thread aThread) {
        List<Object> events = this._events.get(aThread);
        if (events == null) {
            events = Collections.emptyList();
        }
        return Collections.unmodifiableList(events);
    }

    public synchronized int getEventCount(Event aEvent) {
        int count = 0;
        for (Thread thread : this._events.keySet()) {
            List<Event> events = this._events.get(thread);
            for (Event event : events) {
                if (!event.equals(aEvent)) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized int getEventCount() {
        int count = 0;
        for (Thread thread : this._events.keySet()) {
            count += this._events.get(thread).size();
        }
        return count;
    }
}

