/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.wamblee.xml.DomUtils;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static void assertEquals(String aMsg, org.w3c.dom.Document aExpected, org.w3c.dom.Document aActual) {
        XmlUtils.assertEquals(aMsg, DomUtils.convert((org.w3c.dom.Document)aExpected), DomUtils.convert((org.w3c.dom.Document)aActual));
    }

    public static void assertEquals(String aMsg, Document aExpected, Document aActual) {
        XmlUtils.assertEquals(aMsg + "/" + aExpected.getRootElement().getName(), aExpected.getRootElement(), aActual.getRootElement());
    }

    public static void assertEquals(String aMsg, Element aExpected, Element aActual) {
        TestCase.assertEquals((String)(aMsg + "/name()"), (String)aExpected.getName(), (String)aActual.getName());
        TestCase.assertEquals((String)(aMsg + "/text()"), (String)aExpected.getTextTrim(), (String)aActual.getTextTrim());
        List expectedAttrs = aExpected.attributes();
        Collections.sort(expectedAttrs, new AttributeComparator());
        List actualAttrs = aActual.attributes();
        Collections.sort(actualAttrs, new AttributeComparator());
        TestCase.assertEquals((String)("count(" + aMsg + "/@*)"), (int)expectedAttrs.size(), (int)actualAttrs.size());
        for (int i = 0; i < expectedAttrs.size(); ++i) {
            String msg = aMsg + "/@" + ((Attribute)expectedAttrs.get(i)).getName();
            XmlUtils.assertEquals(msg, (Attribute)expectedAttrs.get(i), (Attribute)actualAttrs.get(i));
        }
        List expectedElems = aExpected.elements();
        List actualElems = aActual.elements();
        TestCase.assertEquals((String)("count(" + aMsg + "/*)"), (int)expectedElems.size(), (int)actualElems.size());
        TreeMap<String, Integer> elementIndex = new TreeMap<String, Integer>();
        for (int i = 0; i < expectedElems.size(); ++i) {
            String elemName = ((Element)expectedElems.get(i)).getName();
            Integer index = (Integer)elementIndex.get(elemName);
            if (index == null) {
                index = 1;
            } else {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            elementIndex.put(elemName, index);
            String msg = aMsg + "/" + ((Element)expectedElems.get(i)).getName() + "[" + index + "]";
            XmlUtils.assertEquals(msg, (Element)expectedElems.get(i), (Element)actualElems.get(i));
        }
    }

    public static void assertEquals(String aMsg, Attribute aExpected, Attribute aActual) {
        TestCase.assertEquals((String)(aMsg + ":name"), (String)aExpected.getName(), (String)aActual.getName());
        TestCase.assertEquals((String)(aMsg + ":value"), (String)aExpected.getValue(), (String)aActual.getValue());
    }

    private static final class AttributeComparator
    implements Comparator<Attribute> {
        private AttributeComparator() {
        }

        @Override
        public int compare(Attribute aAttribute1, Attribute aAttribute2) {
            return aAttribute1.getName().compareTo(aAttribute2.getName());
        }
    }
}

