/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.wamblee.io.ClassPathResource;
import org.wamblee.io.FileSystemUtils;
import org.wamblee.xml.ClasspathUriResolver;
import org.wamblee.xml.DomUtils;
import org.wamblee.xml.XmlUtils;
import org.wamblee.xml.XslTransformer;

public class XslTransformerTest
extends TestCase {
    private static final String INCLUDED_XSL_FILE = "utilities.xsl";
    private static final String REPORT_XML = "report.xml";
    private static final String REPORT_TO_HTML_XSLT = "reportToHtml.xsl";
    private static final String REPORT_TO_HTML2_XSLT = "reportToHtml2.xsl";
    private static final String REPORT_TO_HTML_INVALID_XSLT = "reportToHtml-invalid.xsl";
    private static final String REPORT_TO_HTML_NONWELLFORMED_XSLT = "reportToHtml-nonwellformed.xsl";
    private static final String REPORT_TO_TEXT_XSLT = "reportToText.xsl";

    private String getResourcePath(String aResource) {
        return ((Object)((Object)this)).getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + aResource;
    }

    public void testTransformUsingDefaultResolver() throws Exception {
        XslTransformer transformer = new XslTransformer();
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(xmlResource.getInputStream());
        StreamSource documentSource = new StreamSource(xmlResource.getInputStream());
        Document expected = DomUtils.read((InputStream)new ClassPathResource(this.getResourcePath("output-reportToHtml-report.xml")).getInputStream());
        Document output1 = transformer.transform(documentData, (Source)xslt);
        XmlUtils.assertEquals("byte[] transform", expected, output1);
        xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_XSLT)).getInputStream());
        Document output2 = transformer.transform(document, (Source)xslt);
        XmlUtils.assertEquals("document transform", expected, output2);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult output = new StreamResult(os);
        xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_XSLT)).getInputStream());
        transformer.transform((Source)documentSource, (Result)output, (Source)xslt);
        XmlUtils.assertEquals("document source transform", expected, DomUtils.read((String)os.toString()));
        xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_XSLT)).getInputStream());
        String result = transformer.textTransform(documentData, (Source)xslt);
        XmlUtils.assertEquals("text transform", expected, DomUtils.read((String)result));
    }

    public void testTransformUsingDefaultResolverFails() throws IOException {
        XslTransformer transformer = new XslTransformer();
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML2_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        try {
            Document output1 = transformer.transform(documentData, (Source)xslt);
        }
        catch (TransformerException e) {
            return;
        }
        XslTransformerTest.fail();
    }

    public void testTransformInvalidXslt() throws IOException {
        XslTransformer transformer = new XslTransformer();
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_INVALID_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        try {
            Document output1 = transformer.transform(documentData, (Source)xslt);
        }
        catch (TransformerException e) {
            return;
        }
        XslTransformerTest.fail();
    }

    public void testTransformNonWellformedXslt() throws IOException {
        XslTransformer transformer = new XslTransformer();
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML_NONWELLFORMED_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        try {
            Document output1 = transformer.transform(documentData, (Source)xslt);
        }
        catch (TransformerException e) {
            return;
        }
        XslTransformerTest.fail();
    }

    public void testTransformUsingClassPathResolver() throws Exception {
        XslTransformer transformer = new XslTransformer((URIResolver)new ClasspathUriResolver());
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_HTML2_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        Document output1 = transformer.transform(documentData, (Source)xslt);
        Document expected = DomUtils.read((InputStream)new ClassPathResource(this.getResourcePath("output-reportToHtml-report.xml")).getInputStream());
        XmlUtils.assertEquals("doc", expected, output1);
    }

    public void testTransformToTextOutput() throws Exception {
        XslTransformer transformer = new XslTransformer((URIResolver)new ClasspathUriResolver());
        ClassPathResource xmlResource = new ClassPathResource(this.getResourcePath(REPORT_XML));
        StreamSource xslt = new StreamSource(new ClassPathResource(this.getResourcePath(REPORT_TO_TEXT_XSLT)).getInputStream());
        byte[] documentData = FileSystemUtils.read(xmlResource.getInputStream()).getBytes();
        String result = transformer.textTransform(documentData, (Source)xslt);
        String expected = "Hello world!";
        XslTransformerTest.assertEquals((String)"text transform", (String)expected, (String)result);
    }

    public void testResolveWithDefaultResolverFileNotFound() {
        XslTransformer transformer = new XslTransformer();
        try {
            Source source = transformer.resolve("org/wamblee/xml/utilities-nonexistent.xsl");
        }
        catch (TransformerException e) {
            return;
        }
        XslTransformerTest.fail();
    }

    public void testResolveWithClasspathResolver() throws Exception {
        XslTransformer transformer = new XslTransformer((URIResolver)new ClasspathUriResolver());
        Source source = transformer.resolve(this.getResourcePath(INCLUDED_XSL_FILE));
        assert (source instanceof StreamSource);
        StreamSource ssource = (StreamSource)source;
        String data = FileSystemUtils.read(ssource.getInputStream());
        String expected = FileSystemUtils.read(new ClassPathResource(this.getResourcePath(INCLUDED_XSL_FILE)).getInputStream());
        XslTransformerTest.assertEquals((String)expected, (String)data);
    }
}

