<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:include href="org/wamblee/xml/utilities.xsl"/>

<xsl:output method="xml"/>
    <xsl:template match="report">
        <html>
            <head>
                <title>KiSS crawler report</title>
            </head>
            <body>
                <h1>KiSS crawler report</h1>
                <xsl:apply-templates select="recorded"/>
                <xsl:if test="count(interesting) > 0">
                    <h2>Possibly interesting programs</h2>
                    <xsl:apply-templates select="interesting"/>
                </xsl:if>
                <xsl:if test="count(//program) = 0">
                    <xsl:text>No suitable programs found </xsl:text>
                </xsl:if>
            </body>
        </html>

    </xsl:template>

    <xsl:template name="programTable">
        <p>
        <table align="left" cellpadding="5">
            <!-- 
            <tr align="left">
                <th align="left">Time</th>
                <th align="left">Channel</th>
                <th align="left">Program</th>
            </tr>
            -->
            <xsl:apply-templates select="program"/>
        </table>
        <br clear="left"/>
        </p>
    </xsl:template>

    <xsl:template match="recorded">
        <h2>
            <xsl:choose>
                <xsl:when test="@result = 'OK'">
                    <xsl:text>Successfully recorded programs </xsl:text>
                    <xsl:call-template name="programTable"/>
                </xsl:when>
                <xsl:when test="@result = 'DUPLICATE'">
                    <xsl:text>Already recorded programs</xsl:text>
                    <xsl:call-template name="programTable"/>
                </xsl:when>
                <xsl:when test="@result = 'CONFLICT'">
                    <xsl:text>Conflicts with other recorded programs</xsl:text>
                    <xsl:call-template name="programTable"/>
                </xsl:when>
                <xsl:when test="@result='ERROR'">
                    <xsl:text>Programs that could not be recorded for
                    technical reasons.</xsl:text>
                    <xsl:call-template name="programTable"/>
                </xsl:when>
            </xsl:choose>
        </h2>
    </xsl:template>

    <xsl:template name="addProgramInfo">
        <tr align="left">
            <td><xsl:value-of select="interval/begin"/> - <xsl:value-of select="interval/end"/>: <strong>
                    <xsl:value-of select="name"/>
                </strong> (<xsl:value-of select="channel"/>/<xsl:value-of select="keywords"/>)</td>

        </tr>
        <tr>
            <td>
                <blockquote>
                        <font size="-1">
                            <xsl:value-of select="description"/>
                        </font>
                </blockquote>
            </td>


        </tr>
    </xsl:template>

    <xsl:template match="program">
        <xsl:call-template name="addProgramInfo"/>
    </xsl:template>

    <xsl:template match="interesting">
        <xsl:call-template name="programTable"/>
        <xsl:apply-templates select="category"/>
    </xsl:template>

    <xsl:template match="category">
        <h3>Category: <xsl:value-of select="@name"/></h3>
        <xsl:call-template name="programTable"/>
    </xsl:template>
</xsl:stylesheet>

