<?xml version="1.0" encoding="UTF-8"?>

<!-- Note the declaration of the namespace for XInclude. -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
  xmlns:xi="http://www.w3.org/2001/XInclude">


  <xsl:variable name="newline">
    <xsl:text>&#10;</xsl:text>
  </xsl:variable>

  <xsl:variable name="carriageReturn">
    <xsl:text>&#13;&#10;</xsl:text>
  </xsl:variable>

  <!-- =====================================================
    Replace one string by another
    - src: string to do substituion in
    - from: literal string to replace
    - to:substitution string.
    ======================================================-->
  <xsl:template name="string-replace">
    <xsl:param name="src"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:choose>
      <xsl:when test="contains($src, $from)">
        <xsl:value-of select="substring-before($src, $from)"/>
        <xsl:value-of select="$to"/>
        <xsl:call-template name="string-replace">
          <xsl:with-param name="src" select="substring-after($src, $from)"/>
          <xsl:with-param name="from" select="$from"/>
          <xsl:with-param name="to" select="$to"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$src"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="indent">
    <xsl:param name="src"/>
    <xsl:param name="indentString"/>
    <xsl:value-of select="$indentString"/>
    <xsl:call-template name="string-replace">
      <xsl:with-param name="src">
        <xsl:value-of select="$src"/>
      </xsl:with-param>
      <xsl:with-param name="from">
        <xsl:value-of select="$newline"/>
      </xsl:with-param>
      <xsl:with-param name="to">
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$indentString"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="word-wrap">
    <xsl:param name="src"/>
    <xsl:param name="width"/>

    <xsl:call-template name="word-wrap-impl">
      <xsl:with-param name="src">
        <xsl:call-template name="string-replace">
          <xsl:with-param name="src">
            <xsl:value-of select="$src"/>
          </xsl:with-param>
          <xsl:with-param name="from">
            <xsl:text>  </xsl:text>
          </xsl:with-param>
          <xsl:with-param name="to">
            <xsl:text> </xsl:text>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="width">
        <xsl:value-of select="$width"/>
      </xsl:with-param>
      <xsl:with-param name="index">
        <xsl:value-of select="0"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="word-wrap-impl">
    <xsl:param name="src"/>
    <xsl:param name="index"/>
    <xsl:param name="width"/>

    <xsl:variable name="word">
      <xsl:value-of select="substring-before($src, ' ')"/>
    </xsl:variable>
    <xsl:variable name="wordlength">
      <xsl:value-of select="string-length($word)"/>
    </xsl:variable>
    <xsl:variable name="remainder">
      <xsl:value-of select="substring($src, $wordlength+2)"/>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$index + $wordlength + 1 &gt; $width">
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="$word"/>
        <xsl:text> </xsl:text>
        <xsl:if test="string-length($remainder) > 0">
          <xsl:call-template name="word-wrap-impl">
            <xsl:with-param name="src">
              <xsl:value-of select="$remainder"/>
            </xsl:with-param>
            <xsl:with-param name="index">
              <xsl:value-of select="$wordlength + 1"/>
            </xsl:with-param>
            <xsl:with-param name="width">
              <xsl:value-of select="$width"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$word"/>
        <xsl:text> </xsl:text>

        <xsl:if test="string-length($remainder) > 0">
          <xsl:call-template name="word-wrap-impl">
            <xsl:with-param name="src">
              <xsl:value-of select="$remainder"/>
            </xsl:with-param>
            <xsl:with-param name="index">
              <xsl:value-of select="$index + $wordlength+1"/>
            </xsl:with-param>
            <xsl:with-param name="width">
              <xsl:value-of select="$width"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
