/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.wamblee.cache.Cache;

public class CachedObject<KeyType extends Serializable, ValueType extends Serializable> {
    private static final Logger LOGGER = Logger.getLogger(CachedObject.class);
    private Cache<KeyType, ValueType> _cache;
    private KeyType _objectKey;
    private Computation<KeyType, ValueType> _computation;

    public CachedObject(Cache<KeyType, ValueType> aCache, KeyType aObjectKey, Computation<KeyType, ValueType> aComputation) {
        this._cache = aCache;
        this._objectKey = aObjectKey;
        this._computation = aComputation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType get() {
        ValueType object = this._cache.get(this._objectKey);
        if (object == null) {
            CachedObject cachedObject = this;
            synchronized (cachedObject) {
                object = this._cache.get(this._objectKey);
                if (object == null) {
                    LOGGER.debug((Object)("Refreshing cache for '" + this._objectKey + "'"));
                    object = this._computation.getObject(this._objectKey);
                    this._cache.put(this._objectKey, object);
                }
            }
        }
        return object;
    }

    public void invalidate() {
        this._cache.remove(this._objectKey);
    }

    public Cache getCache() {
        return this._cache;
    }

    public static interface Computation<Key extends Serializable, Value extends Serializable> {
        public Value getObject(Key var1);
    }
}

