/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.wamblee.cache.Cache;
import org.wamblee.io.InputResource;

public class EhCache<KeyType extends Serializable, ValueType extends Serializable>
implements Cache<KeyType, ValueType> {
    private static final Logger LOGGER = Logger.getLogger(EhCache.class);
    private CacheManager _manager;
    private net.sf.ehcache.Cache _cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EhCache(InputResource aResource, String aCacheName) throws IOException, CacheException {
        InputStream is = aResource.getInputStream();
        try {
            this._manager = new CacheManager(is);
            this._cache = this._manager.getCache(aCacheName);
            if (this._cache == null) {
                LOGGER.warn((Object)("Creating cache '" + aCacheName + "' because it is not configured"));
                this._manager.addCache(aCacheName);
                this._cache = this._manager.getCache(aCacheName);
            }
            assert (this._cache != null);
        }
        finally {
            is.close();
        }
    }

    @Override
    public void put(KeyType aKey, ValueType aValue) {
        this._cache.put(new Element(aKey, aValue));
    }

    @Override
    public ValueType get(KeyType aKey) {
        try {
            Element element = this._cache.get(aKey);
            if (element == null) {
                return null;
            }
            return (ValueType)element.getValue();
        }
        catch (CacheException e) {
            throw new RuntimeException("Cache problem key = '" + aKey + "'", e);
        }
    }

    @Override
    public void remove(KeyType aKey) {
        this._cache.remove(aKey);
    }

    @Override
    public void clear() {
        this._cache.removeAll();
    }
}

