/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import java.util.HashSet;

public class ReadWriteLock {
    private HashSet<Thread> _readers = new HashSet();
    private Thread _writer = null;

    public synchronized void acquireRead() {
        if (this._readers.contains(Thread.currentThread())) {
            throw new IllegalStateException("Read lock already acquired by current thread: " + Thread.currentThread());
        }
        if (this._writer == Thread.currentThread()) {
            throw new IllegalStateException("Trying to acquire the read lock while already holding a write lock: " + Thread.currentThread());
        }
        while (this._writer != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.notifyAll();
            }
        }
        this._readers.add(Thread.currentThread());
    }

    public synchronized void releaseRead() {
        if (!this._readers.remove(Thread.currentThread())) {
            throw new IllegalStateException("Cannot release read lock because current thread has not acquired it.");
        }
        if (this._readers.size() == 0) {
            this.notifyAll();
        }
    }

    public synchronized void acquireWrite() {
        if (this._writer == Thread.currentThread()) {
            throw new IllegalStateException("Trying to acquire a write lock while already holding the write lock: " + Thread.currentThread());
        }
        if (this._readers.contains(Thread.currentThread())) {
            throw new IllegalStateException("Trying to acquire a write lock while already holding the read lock: " + Thread.currentThread());
        }
        while (this._writer != null || this._readers.size() > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.notifyAll();
            }
        }
        this._writer = Thread.currentThread();
    }

    public synchronized void releaseWrite() {
        if (this._writer != Thread.currentThread()) {
            throw new IllegalStateException("Cannot release write lock because it was not acquired. ");
        }
        this._writer = null;
        this.notifyAll();
    }
}

