/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.conditions;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.wamblee.conditions.Condition;

public class PropertyRegexCondition<T>
implements Condition<T> {
    private String _property;
    private Pattern _regex;
    private boolean _tolower;

    public PropertyRegexCondition(String aProperty, String aRegex, boolean aTolower) {
        this._property = aProperty;
        this._regex = Pattern.compile(aRegex);
        this._tolower = aTolower;
    }

    @Override
    public boolean matches(T aObject) {
        try {
            String value = PropertyUtils.getProperty(aObject, (String)this._property) + "";
            if (this._tolower) {
                value = value.toLowerCase();
            }
            Matcher matcher = this._regex.matcher(value);
            return matcher.matches();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

