/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryMonitor {
    private static final Log LOG = LogFactory.getLog(DirectoryMonitor.class);
    private File _directory;
    private FileFilter _filter;
    private Listener _listener;
    private Map<File, Date> _contents;

    public DirectoryMonitor(File aDirectory, FileFilter aFilefilter, Listener aListener) {
        this._directory = aDirectory;
        if (!this._directory.isDirectory()) {
            throw new IllegalArgumentException("Directory '" + this._directory + "' does not exist");
        }
        this._filter = aFilefilter;
        this._listener = aListener;
        this._contents = new HashMap<File, Date>();
    }

    public void poll() {
        LOG.debug((Object)("Polling " + this._directory));
        HashMap<File, Date> newContents = new HashMap<File, Date>();
        File[] files = this._directory.listFiles(this._filter);
        HashSet<File> deletedFiles = new HashSet<File>(this._contents.keySet());
        for (File file : files) {
            if (!file.isFile() || !this._contents.containsKey(file)) continue;
            deletedFiles.remove(file);
        }
        for (File file : deletedFiles) {
            this._listener.fileDeleted(file);
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            if (this._contents.containsKey(file)) {
                Date oldDate = this._contents.get(file);
                if (file.lastModified() != oldDate.getTime()) {
                    this._listener.fileChanged(file);
                }
                newContents.put(file, new Date(file.lastModified()));
                continue;
            }
            this._listener.fileCreated(file);
            newContents.put(file, new Date(file.lastModified()));
        }
        this._contents = newContents;
    }

    public static interface Listener {
        public void fileChanged(File var1);

        public void fileCreated(File var1);

        public void fileDeleted(File var1);
    }
}

