/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleProcess {
    private static final Log LOG = LogFactory.getLog(SimpleProcess.class);
    private File _directory;
    private String[] _cmd;
    private String _stdout;
    private String _stderr;

    public SimpleProcess(File aDirectory, String[] aCmd) {
        this._directory = aDirectory;
        this._cmd = aCmd;
    }

    public String getStdout() {
        return this._stdout;
    }

    public String getStderr() {
        return this._stderr;
    }

    public int run() throws IOException {
        return this.runImpl();
    }

    private int runImpl() throws IOException {
        try {
            String fullcmd = "";
            for (String part : this._cmd) {
                fullcmd = fullcmd + " " + part;
            }
            LOG.debug((Object)("Executing '" + fullcmd + "' in directory '" + this._directory + "'"));
            Process proc = Runtime.getRuntime().exec(this._cmd, null, this._directory);
            StringWriter stdout = new StringWriter();
            StringWriter stderr = new StringWriter();
            Thread stdoutReader = this.readAndLogStream("STDOUT>  ", proc.getInputStream(), stdout);
            Thread stderrReader = this.readAndLogStream("STDERR>  ", proc.getErrorStream(), stderr);
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                IOException exception = new IOException("Process was terminated: " + this);
                exception.initCause(e);
                throw exception;
            }
            this.waitForReader(stdoutReader);
            this.waitForReader(stderrReader);
            this._stdout = stdout.toString();
            this._stderr = stderr.toString();
            if (proc.exitValue() != 0) {
                LOG.warn((Object)("Exit value was non-zero: " + this));
            } else {
                LOG.debug((Object)"Process finished");
            }
            return proc.exitValue();
        }
        catch (IOException e) {
            IOException exception = new IOException("Error executing process: " + this);
            exception.initCause(e);
            throw exception;
        }
    }

    private void waitForReader(Thread aReaderThread) {
        try {
            aReaderThread.join();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)(this + ": error waiting for output stream reader of process to finish"));
        }
    }

    private Thread readAndLogStream(final String aPrefix, final InputStream aStream, final Writer aOutput) {
        Thread inputReader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String str;
                    br = new BufferedReader(new InputStreamReader(aStream));
                    while ((str = br.readLine()) != null) {
                        LOG.debug((Object)(aPrefix + str));
                        aOutput.write(str);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)(SimpleProcess.this + ": error reading input stream"), (Throwable)e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Error closing stream " + aPrefix));
                        }
                    }
                }
            }
        };
        inputReader.start();
        return inputReader;
    }

    public String toString() {
        String fullcmd = "";
        for (String part : this._cmd) {
            fullcmd = fullcmd + part + " ";
        }
        return "process(dir = '" + this._directory + "', cmd = '" + fullcmd + "')";
    }
}

