/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.observer;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.wamblee.observer.Observer;
import org.wamblee.observer.ObserverNotifier;

public class Observable<ObservableType, Event> {
    private static final Logger LOGGER = Logger.getLogger(Observable.class);
    private ObservableType _observable;
    private ObserverNotifier<ObservableType, Event> _notifier;
    private Map<Long, Observer<ObservableType, Event>> _observers;
    private long _counter;

    public Observable(ObservableType aObservable, ObserverNotifier<ObservableType, Event> aNotifier) {
        this._observable = aObservable;
        this._notifier = aNotifier;
        this._observers = new TreeMap<Long, Observer<ObservableType, Event>>();
        this._counter = 0L;
    }

    public synchronized long subscribe(Observer<ObservableType, Event> aObserver) {
        long subscription = this._counter++;
        this._observers.put(subscription, aObserver);
        return subscription;
    }

    public synchronized void unsubscribe(long aSubscription) {
        Observer<ObservableType, Event> obj = this._observers.remove(aSubscription);
        if (obj == null) {
            throw new IllegalArgumentException("Subscription '" + aSubscription + "'");
        }
    }

    public int getObserverCount() {
        return this._observers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Event aEvent) {
        ArrayList<Observer<ObservableType, Event>> observers = new ArrayList<Observer<ObservableType, Event>>();
        Observable observable = this;
        synchronized (observable) {
            observers.addAll(this._observers.values());
        }
        for (Observer observer : observers) {
            this._notifier.update(observer, this._observable, aEvent);
        }
    }

    protected void finalize() throws Throwable {
        if (this._observers.size() > 0) {
            LOGGER.error((Object)"Still observers registered at finalization of observer!");
            for (Observer<ObservableType, Event> observer : this._observers.values()) {
                LOGGER.error((Object)("  observer: " + observer));
            }
        }
        super.finalize();
    }
}

