/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.concurrency;

import java.util.concurrent.locks.ReentrantLock;

/**
 * In memory JVM lock.
 * 
 * @author Erik Brakkee
 */
public class JvmLock implements Lock {
    /**
     * Reentrant lock to use.
     */
    private ReentrantLock lock;

    /**
     * In-memory lock.
     */
    public JvmLock() {
        lock = new ReentrantLock(true);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.concurrency.Lock#acquire()
     */
    public void acquire() {
        lock.lock();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.concurrency.Lock#release()
     */
    public void release() {
        lock.unlock();
    }
}
