/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.observer;

/**
 * Default observer notifier which calls
 * {@link org.wamblee.observer.Observer#send(ObservableType, Event)}
 * immediately.
 * 
 * @author Erik Brakkee
 */
public class DefaultObserverNotifier<ObservableType, Event> implements
    ObserverNotifier<ObservableType, Event> {
    /**
     * Constructs the notifier.
     * 
     */
    public DefaultObserverNotifier() {
        // Empty
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.wamblee.observer.ObserverNotifier#update(org.wamblee.observer.Observer
     * , ObservableType, Event)
     */
    public void update(Observer<ObservableType, Event> aObserver,
        ObservableType aObservable, Event aEvent) {
        aObserver.send(aObservable, aEvent);
    }
}
