/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.xml;

import org.wamblee.io.ClassPathResource;
import org.wamblee.io.InputResource;

import java.io.IOException;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

/**
 * URI resolver that resolves stylesheets through the classpath.
 */
public class ClasspathUriResolver implements URIResolver {
    /**
     * Constructs the resolver.
     * 
     */
    public ClasspathUriResolver() {
        // Empty.
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.xml.transform.URIResolver#resolve(java.lang.String,
     * java.lang.String)
     */
    public Source resolve(String aHref, String aBase)
        throws TransformerException {
        InputResource xslt = new ClassPathResource(aHref);

        try {
            return new StreamSource(xslt.getInputStream());
        } catch (IOException e) {
            throw new TransformerException(
                "Could not get XSLT style sheet in classpath '" + aHref + "'",
                e);
        }
    }
}
