/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import junit.framework.TestCase;
import org.wamblee.general.BeanFactory;
import org.wamblee.general.BeanFactoryException;
import org.wamblee.general.BeanKernel;
import org.wamblee.general.TestBeanFactory;

public class BeanKernelTest
extends TestCase {
    public void testLoadBeanFactoryFromProperties() {
        BeanFactory factory = BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel.properties");
        BeanKernelTest.assertTrue((boolean)(factory instanceof TestBeanFactory));
    }

    public void testNonExistentPropertyFile() {
        try {
            BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel-nonexistent.properties");
        }
        catch (BeanFactoryException e) {
            return;
        }
        BeanKernelTest.fail();
    }

    public void testNonExistentBeanFactory() {
        try {
            BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel-wrong.properties");
        }
        catch (BeanFactoryException e) {
            return;
        }
        BeanKernelTest.fail();
    }

    public void testRetrieveFactory() {
        BeanKernel.overrideBeanFactory((BeanFactory)new TestBeanFactory());
        BeanFactory factory = BeanKernel.getBeanFactory();
        BeanKernelTest.assertNotNull((Object)factory);
        BeanKernelTest.assertEquals((String)"hello", (String)((String)factory.find(String.class)));
    }
}

