/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AssertionUtils {
    private static final Log LOG = LogFactory.getLog(AssertionUtils.class);

    private AssertionUtils() {
    }

    public static <T> void assertEquals(T[] aExpected, T[] aActual) {
        AssertionUtils.assertEquals("", aExpected, aActual);
    }

    public static <T> void assertEquals(String aMsg, T[] aExpected, T[] aActual) {
        TestCase.assertEquals((String)(aMsg + " expected " + Arrays.asList(aExpected) + ", actual " + Arrays.asList(aActual) + ": Array lengths "), (int)aExpected.length, (int)aActual.length);
        for (int i = 0; i < aExpected.length; ++i) {
            TestCase.assertEquals((String)(aMsg + ": Element " + i), aExpected[i], aActual[i]);
        }
    }

    public static <T> void assertEquals(String aMsg, T aExpected, T aActual) {
        if (aExpected instanceof Object[]) {
            AssertionUtils.assertEquals(aMsg, (Object[])aExpected, (Object[])aActual);
            return;
        }
        TestCase.assertEquals((String)aMsg, aExpected, aActual);
    }

    public static <Key, Value> void assertEquals(String aMsg, Map<Key, Value> aExpectedMap, Map<Key, Value> aActual) {
        TestCase.assertEquals((String)"Map sizes differ", (int)aExpectedMap.size(), (int)aActual.size());
        Set<Map.Entry<Key, Value>> expectedEntries = aExpectedMap.entrySet();
        for (Map.Entry<Key, Value> entry : expectedEntries) {
            Key key = entry.getKey();
            TestCase.assertTrue((String)("Map does not containg entry for key:" + key), (boolean)aActual.containsKey(key));
            AssertionUtils.assertEquals("Value of key " + key + " of map", entry.getValue(), aActual.get(key));
        }
    }

    public static void assertException(ErroneousCode aObject, Class aType) {
        try {
            aObject.run();
            throw new RuntimeException("No exception occurred");
        }
        catch (Throwable t) {
            if (aType.isInstance(t)) {
                LOG.info((Object)("Expected exception occured " + t.getMessage()));
                return;
            }
            throw new RuntimeException(t);
        }
    }

    public static interface ErroneousCode {
        public void run() throws Exception;
    }
}

