/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.cache;

import java.io.Serializable;

/**
 * The <code>Cache</code> interface represents... a cache. In some circumstances
 * it is more optimal to implement caching directly in the code instead of
 * relying on Hibernate caching methods. This interface abstracts from the used
 * cache implementation. Cache implementations must be thread-safe.
 */
public interface Cache<KeyType extends Serializable, ValueType extends Serializable> {
    /**
     * Adds a key-value pair to the cache.
     * 
     * @param aKey
     *            Key.
     * @param aValue
     *            Value.
     */
    void put(KeyType aKey, ValueType aValue);

    /**
     * Retrieves a value from the cache.
     * 
     * @param aKey
     *            Key to retrieve.
     * 
     * @return Key.
     */
    ValueType get(KeyType aKey);

    /**
     * Removes an entry from the cache.
     * 
     * @param aKey
     *            Key to remove the entry for.
     */
    void remove(KeyType aKey);

    /**
     * Removes all entries from the cache.
     */
    void clear();
}
