/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import junit.framework.TestCase;
import org.wamblee.test.EventTracker;
import org.wamblee.test.TimingUtils;

public abstract class AbstractLockTestCase
extends TestCase {
    protected static final int SLEEP_TIME = 1000;
    protected static final String STARTED = "started";
    protected static final String ACQUIRED = "acquired";
    protected static final String RELEASED = "released";
    private EventTracker<String> tracker;

    protected void setUp() throws Exception {
        this.tracker = new EventTracker();
    }

    protected EventTracker<String> getTracker() {
        return this.tracker;
    }

    protected abstract Thread runThread();

    public void testLock() throws InterruptedException {
        Thread t1 = this.runThread();
        Thread t2 = this.runThread();
        TimingUtils.sleep(100);
        AbstractLockTestCase.assertEquals((int)2, (int)this.tracker.getEventCount(STARTED));
        AbstractLockTestCase.assertEquals((int)1, (int)this.tracker.getEventCount(ACQUIRED));
        TimingUtils.sleep(1000);
        AbstractLockTestCase.assertEquals((int)2, (int)this.tracker.getEventCount(ACQUIRED));
        AbstractLockTestCase.assertEquals((int)1, (int)this.tracker.getEventCount(RELEASED));
        TimingUtils.sleep(1000);
        AbstractLockTestCase.assertEquals((int)2, (int)this.tracker.getEventCount(RELEASED));
        t1.join();
        t2.join();
    }
}

