/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.conditions;

import junit.framework.TestCase;
import org.wamblee.conditions.PropertyRegexCondition;
import org.wamblee.conditions.TestBean;

public class PropertyRegexConditionTest
extends TestCase {
    private boolean match(String aProperty, String aRegex, boolean aToLower, TestBean aBean) {
        PropertyRegexCondition condition = new PropertyRegexCondition(aProperty, aRegex, aToLower);
        return condition.matches((Object)aBean);
    }

    private void checkMatch(String aProperty, String aRegex, boolean aToLower, TestBean aBean, boolean aResult) {
        PropertyRegexConditionTest.assertEquals((boolean)aResult, (boolean)this.match(aProperty, aRegex, aToLower, aBean));
    }

    public void testMatchProperty() {
        TestBean bean = new TestBean("Hallo");
        this.checkMatch("value", "Hallo", false, bean, true);
        this.checkMatch("value", "all", false, bean, false);
        this.checkMatch("value", ".a.*o", false, bean, true);
        this.checkMatch("value", "hallo", false, bean, false);
        this.checkMatch("value", "hallo", true, bean, true);
    }

    public void testWrongProperty() {
        TestBean bean = new TestBean("Hallo");
        try {
            this.match("bla", ".*", false, bean);
        }
        catch (RuntimeException e) {
            return;
        }
        PropertyRegexConditionTest.fail();
    }

    public void testPrivateProperty() {
        TestBean bean = new TestBean("Hallo");
        try {
            this.match("privateValue", ".*", false, bean);
        }
        catch (RuntimeException e) {
            return;
        }
        PropertyRegexConditionTest.fail();
    }
}

