/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.wamblee.io.ClassPathResource;
import org.wamblee.io.FileSystemUtils;

public final class TestData {
    private File root;

    public TestData(Object aTestcase) {
        this.root = TestData.getTestRootDir(aTestcase);
        FileSystemUtils.createDir(this.root);
    }

    private static File getTestRootDir(Object aTestcase) {
        return FileSystemUtils.getTestOutputDir(aTestcase.getClass());
    }

    public void createFile(String aRelative, String aFile, InputStream aContents) {
        FileSystemUtils.createFile(new File(this.root, aRelative), aFile, aContents);
    }

    public void createFile(String aFile, String aContents) {
        this.createFile(".", aFile, aContents);
    }

    public void createFile(String aRelative, String aFile, String aContents) {
        ByteArrayInputStream is = new ByteArrayInputStream(aContents.getBytes());
        FileSystemUtils.createFile(new File(this.root, aRelative), aFile, is);
    }

    public void deleteFile(String aFile) {
        this.deleteFile(".", aFile);
    }

    public void deleteFile(String aRelative, String aFile) {
        FileSystemUtils.delete(new File(this.root, aFile));
    }

    public File getTmpDir() {
        return new File(this.root, "tmpdir");
    }

    public void clean() {
        FileSystemUtils.deleteDirRecursively(this.root);
        FileSystemUtils.createDir(this.root);
    }

    public void copyDir(File aSrc) {
        FileSystemUtils.copyDir(aSrc, this.root);
    }

    public void copyResource(String aResource, String aRelativePath) {
        try {
            InputStream is = new ClassPathResource(aResource).getInputStream();
            FileOutputStream fos = new FileOutputStream(new File(this.root, aRelativePath));
            FileSystemUtils.copyStream(is, fos);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void copyResource(String aResource) {
        String basename = new File(aResource).getName();
        this.copyResource(aResource, basename);
    }

    public void createDir(String aRelative) {
        FileSystemUtils.createDir(new File(this.root, aRelative));
    }

    public void delete(String aRelative) {
        FileSystemUtils.delete(new File(this.root, aRelative));
    }

    public void deleteDir(String aRelative) {
        FileSystemUtils.deleteDir(new File(this.root, aRelative));
    }

    public void deleteDirRecursively(String aRelative) {
        FileSystemUtils.deleteDir(new File(this.root, aRelative));
    }

    public File getRoot() {
        return this.root;
    }

    public File getFile(String aRelative) {
        return new File(this.root, aRelative);
    }
}

