/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.wamblee.cache.Cache;

public class CachedObject<KeyType extends Serializable, ValueType extends Serializable> {
    private static final Logger LOGGER = Logger.getLogger(CachedObject.class);
    private Cache<KeyType, ValueType> cache;
    private KeyType objectKey;
    private Computation<KeyType, ValueType> computation;

    public CachedObject(Cache<KeyType, ValueType> aCache, KeyType aObjectKey, Computation<KeyType, ValueType> aComputation) {
        this.cache = aCache;
        this.objectKey = aObjectKey;
        this.computation = aComputation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType get() {
        ValueType object = this.cache.get(this.objectKey);
        if (object == null) {
            CachedObject cachedObject = this;
            synchronized (cachedObject) {
                object = this.cache.get(this.objectKey);
                if (object == null) {
                    LOGGER.debug((Object)("Refreshing cache for '" + this.objectKey + "'"));
                    object = this.computation.getObject(this.objectKey);
                    this.cache.put(this.objectKey, object);
                }
            }
        }
        return object;
    }

    public void invalidate() {
        this.cache.remove(this.objectKey);
    }

    public Cache getCache() {
        return this.cache;
    }

    public static interface Computation<Key extends Serializable, Value extends Serializable> {
        public Value getObject(Key var1);
    }
}

