/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import java.util.HashSet;

public class ReadWriteLock {
    private HashSet<Thread> readers = new HashSet();
    private Thread writer = null;

    public synchronized void acquireRead() {
        if (this.readers.contains(Thread.currentThread())) {
            throw new IllegalStateException("Read lock already acquired by current thread: " + Thread.currentThread());
        }
        if (this.writer == Thread.currentThread()) {
            throw new IllegalStateException("Trying to acquire the read lock while already holding a write lock: " + Thread.currentThread());
        }
        while (this.writer != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.notifyAll();
            }
        }
        this.readers.add(Thread.currentThread());
    }

    public synchronized void releaseRead() {
        if (!this.readers.remove(Thread.currentThread())) {
            throw new IllegalStateException("Cannot release read lock because current thread has not acquired it.");
        }
        if (this.readers.size() == 0) {
            this.notifyAll();
        }
    }

    public synchronized void acquireWrite() {
        if (this.writer == Thread.currentThread()) {
            throw new IllegalStateException("Trying to acquire a write lock while already holding the write lock: " + Thread.currentThread());
        }
        if (this.readers.contains(Thread.currentThread())) {
            throw new IllegalStateException("Trying to acquire a write lock while already holding the read lock: " + Thread.currentThread());
        }
        while (this.writer != null || this.readers.size() > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.notifyAll();
            }
        }
        this.writer = Thread.currentThread();
    }

    public synchronized void releaseWrite() {
        if (this.writer != Thread.currentThread()) {
            throw new IllegalStateException("Cannot release write lock because it was not acquired. ");
        }
        this.writer = null;
        this.notifyAll();
    }
}

