/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wamblee.general.BeanFactory;
import org.wamblee.general.BeanFactoryException;
import org.wamblee.io.ClassPathResource;

public final class BeanKernel {
    private static final Log LOG = LogFactory.getLog(BeanKernel.class);
    private static final String BEAN_KERNEL_PROP_FILE = "org.wamblee.beanfactory.properties";
    private static final String BEAN_FACTORY_CLASS = "org.wamblee.beanfactory.class";
    private static BeanFactory BEAN_FACTORY;

    private BeanKernel() {
    }

    public static void overrideBeanFactory(BeanFactory aOverride) {
        BEAN_FACTORY = aOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactory getBeanFactory() {
        Class<BeanFactory> clazz = BeanFactory.class;
        synchronized (BeanFactory.class) {
            if (BEAN_FACTORY == null) {
                BEAN_FACTORY = BeanKernel.lookupBeanFactory(BEAN_KERNEL_PROP_FILE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN_FACTORY;
        }
    }

    static BeanFactory lookupBeanFactory(String aPropertyFilename) {
        InputStream is;
        ClassPathResource resource = new ClassPathResource(aPropertyFilename);
        try {
            is = resource.getInputStream();
        }
        catch (IOException e) {
            throw new BeanFactoryException("Cannot open resource " + resource, e);
        }
        try {
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty(BEAN_FACTORY_CLASS);
            Class<?> beanFactory = Class.forName(className);
            BeanFactory beanFactory2 = (BeanFactory)beanFactory.newInstance();
            return beanFactory2;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Cannot read from resource " + resource, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Error closing resource " + resource));
            }
        }
    }
}

