/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wamblee.persistence.Persistent;
import org.wamblee.persistence.PersistentFactory;
import org.wamblee.reflection.ReflectionUtils;

public class JpaMergeSupport {
    private static final Log LOG = LogFactory.getLog(JpaMergeSupport.class);

    public static void merge(Object aMerged, Object aPersistent) {
        JpaMergeSupport.processPersistent(aMerged, aPersistent, new ArrayList<ObjectElem>());
    }

    public static void processPersistent(Object aMerged, Object aPersistent, List<ObjectElem> aProcessed) {
        if (aPersistent == null && aMerged == null) {
            return;
        }
        if (aPersistent == null || aMerged == null) {
            throw new RuntimeException("persistent or merged object is null '" + aPersistent + "'" + "  '" + aMerged + "'");
        }
        ObjectElem elem = new ObjectElem(aPersistent);
        if (aProcessed.contains(elem)) {
            return;
        }
        aProcessed.add(elem);
        LOG.debug((Object)("Setting pk/version on " + aPersistent + " from " + aMerged));
        Persistent persistentWrapper = PersistentFactory.create(aPersistent);
        Persistent mergedWrapper = PersistentFactory.create(aMerged);
        if (persistentWrapper == null) {
            return;
        }
        Serializable pk = persistentWrapper.getPrimaryKey();
        boolean pkIsNull = false;
        if (pk instanceof Number) {
            pkIsNull = ((Number)pk).longValue() == 0L;
        } else {
            boolean bl = pkIsNull = pk == null;
        }
        if (!pkIsNull && !mergedWrapper.getPrimaryKey().equals(persistentWrapper.getPrimaryKey())) {
            throw new IllegalArgumentException("Mismatch between primary key values: " + aPersistent + " " + aMerged);
        }
        persistentWrapper.setPersistedVersion(mergedWrapper.getPersistedVersion());
        persistentWrapper.setPrimaryKey(mergedWrapper.getPrimaryKey());
        List<Method> methods = ReflectionUtils.getAllMethods(aPersistent.getClass(), Object.class);
        for (Method getter : methods) {
            if (!getter.getName().startsWith("get") && !getter.getName().startsWith("is") || Modifier.isStatic(getter.getModifiers()) || !Modifier.isPublic(getter.getModifiers()) || getter.getParameterTypes().length != 0 || getter.getReturnType() == Void.class) continue;
            Class<?> returnType = getter.getReturnType();
            try {
                Object[] persistent;
                Object[] merged;
                if (Set.class.isAssignableFrom(returnType)) {
                    merged = (Set)getter.invoke(aMerged, new Object[0]);
                    persistent = (Set)getter.invoke(aPersistent, new Object[0]);
                    JpaMergeSupport.processSet((Set)merged, (Set)persistent, aProcessed);
                    continue;
                }
                if (List.class.isAssignableFrom(returnType)) {
                    merged = (List)getter.invoke(aMerged, new Object[0]);
                    persistent = (List)getter.invoke(aPersistent, new Object[0]);
                    JpaMergeSupport.processList((List)merged, (List)persistent, aProcessed);
                    continue;
                }
                if (Map.class.isAssignableFrom(returnType)) {
                    merged = (Map)getter.invoke(aMerged, new Object[0]);
                    persistent = (Map)getter.invoke(aPersistent, new Object[0]);
                    JpaMergeSupport.processMap(merged, persistent, aProcessed);
                    continue;
                }
                if (returnType.isArray()) {
                    merged = (Object[])getter.invoke(aMerged, new Object[0]);
                    if (merged.length != (persistent = (Object[])getter.invoke(aPersistent, new Object[0])).length) {
                        throw new IllegalArgumentException("Array sizes differ " + merged.length + " " + persistent.length);
                    }
                    for (int i = 0; i < persistent.length; ++i) {
                        JpaMergeSupport.processPersistent(merged[i], persistent[i], aProcessed);
                    }
                    continue;
                }
                merged = getter.invoke(aMerged, new Object[0]);
                persistent = getter.invoke(aPersistent, new Object[0]);
                JpaMergeSupport.processPersistent(merged, persistent, aProcessed);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static void processList(List aMerged, List aPersistent, List<ObjectElem> aProcessed) {
        Object[] persistent;
        Object[] merged = aMerged.toArray();
        if (merged.length != (persistent = aPersistent.toArray()).length) {
            throw new IllegalArgumentException("Array sizes differ " + merged.length + " " + persistent.length);
        }
        for (int i = 0; i < merged.length; ++i) {
            assert (merged[i].equals(persistent[i]));
            JpaMergeSupport.processPersistent(merged[i], persistent[i], aProcessed);
        }
    }

    public static void processSet(Set aMerged, Set aPersistent, List<ObjectElem> aProcessed) {
        if (aMerged.size() != aPersistent.size()) {
            throw new IllegalArgumentException("Array sizes differ " + aMerged.size() + " " + aPersistent.size());
        }
        block0: for (Object merged : aMerged) {
            for (Object persistent : aPersistent) {
                if (!persistent.equals(merged)) continue;
                JpaMergeSupport.processPersistent(merged, persistent, aProcessed);
                continue block0;
            }
        }
    }

    public static <Key, Value> void processMap(Map<Key, Value> aMerged, Map<Key, Value> aPersistent, List<ObjectElem> aProcessed) {
        if (aMerged.size() != aPersistent.size()) {
            throw new IllegalArgumentException("Sizes differ " + aMerged.size() + " " + aPersistent.size());
        }
        Set<Map.Entry<Key, Value>> entries = aMerged.entrySet();
        for (Map.Entry<Key, Value> entry : entries) {
            Key key = entry.getKey();
            if (!aPersistent.containsKey(key)) {
                throw new IllegalArgumentException("Key '" + key + "' not found");
            }
            Value mergedValue = entry.getValue();
            Value persistentValue = aPersistent.get(key);
            JpaMergeSupport.processPersistent(mergedValue, persistentValue, aProcessed);
        }
    }

    private static final class ObjectElem {
        private Object object;

        public ObjectElem(Object aObject) {
            this.object = aObject;
        }

        public boolean equals(Object aObj) {
            if (aObj == null) {
                return false;
            }
            if (!(aObj instanceof ObjectElem)) {
                return false;
            }
            return ((ObjectElem)aObj).object == this.object;
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }
}

