/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Id;
import javax.persistence.Version;
import org.wamblee.persistence.Persistent;
import org.wamblee.reflection.ReflectionUtils;

public class PersistentFactory {
    private static Map<String, EntityAccessor> CACHE = new ConcurrentHashMap<String, EntityAccessor>();

    public static EntityAccessor createEntityAccessor(Class aClass) {
        EntityAccessor accessor = CACHE.get(aClass.getName());
        if (accessor == null && (accessor = PersistentFactory.analyse(aClass)) != null) {
            CACHE.put(aClass.getName(), accessor);
        }
        return accessor;
    }

    private static EntityAccessor analyse(Class aClass) {
        Accessor pk = PersistentFactory.analyse(aClass, Id.class);
        Accessor version = PersistentFactory.analyse(aClass, Version.class);
        if (pk != null || version != null) {
            return new EntityAccessor(pk, version);
        }
        return null;
    }

    private static Accessor analyse(Class aClass, Class<? extends Annotation> aAnnotation) {
        List<Field> fields = ReflectionUtils.getAllFields(aClass, new Class[0]);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(aAnnotation)) continue;
            return new FieldAccessor(field);
        }
        List<Method> methods = ReflectionUtils.getAllMethods(aClass, Object.class);
        for (Method method : methods) {
            if (!method.isAnnotationPresent(aAnnotation)) continue;
            String setterName = null;
            if (method.getName().startsWith("get")) {
                setterName = method.getName().replaceFirst("get", "set");
            } else if (method.getName().startsWith("is")) {
                setterName = method.getName().replaceFirst("is", "set");
            }
            try {
                Class<?> returnType = method.getReturnType();
                Method setter = method.getDeclaringClass().getDeclaredMethod(setterName, returnType);
                return new PropertyAccessor(method, setter);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Error obtaining setter for " + method.getName() + " in class " + aClass.getName(), e);
            }
        }
        return null;
    }

    public static Persistent create(Object aEntity) {
        EntityAccessor accessor = PersistentFactory.createEntityAccessor(aEntity.getClass());
        if (accessor == null) {
            return null;
        }
        return new EntityObjectAccessor(aEntity, accessor);
    }

    public static class EntityObjectAccessor
    implements Persistent {
        private EntityAccessor accessor;
        private Object entity;

        public EntityObjectAccessor(Object aEntity, EntityAccessor aAccessor) {
            this.accessor = aAccessor;
            this.entity = aEntity;
        }

        public EntityAccessor getAccessor() {
            return this.accessor;
        }

        @Override
        public Serializable getPrimaryKey() {
            if (this.accessor == null || this.accessor.getPk() == null) {
                return null;
            }
            return (Serializable)this.accessor.getPk().get(this.entity);
        }

        @Override
        public void setPrimaryKey(Serializable aKey) {
            if (this.accessor == null || this.accessor.getPk() == null) {
                return;
            }
            this.accessor.getPk().set(this.entity, aKey);
        }

        @Override
        public Number getPersistedVersion() {
            if (this.accessor == null || this.accessor.getVersion() == null) {
                return null;
            }
            return (Number)this.accessor.getVersion().get(this.entity);
        }

        @Override
        public void setPersistedVersion(Number aVersion) {
            if (this.accessor == null || this.accessor.getVersion() == null) {
                return;
            }
            this.accessor.getVersion().set(this.entity, aVersion);
        }
    }

    static class EntityAccessor {
        private Accessor pk;
        private Accessor version;

        public EntityAccessor(Accessor<?> aPk, Accessor<?> aVersion) {
            this.pk = aPk;
            this.version = aVersion;
        }

        public Accessor getPk() {
            return this.pk;
        }

        public Accessor getVersion() {
            return this.version;
        }
    }

    static class PropertyAccessor<T>
    implements Accessor<T> {
        private Method getter;
        private Method setter;

        public PropertyAccessor(Method aGetter, Method aSetter) {
            this.getter = aGetter;
            this.setter = aSetter;
            this.getter.setAccessible(true);
            this.setter.setAccessible(true);
        }

        @Override
        public T get(Object aEntity) {
            try {
                return (T)this.getter.invoke(aEntity, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void set(Object aEntity, T aValue) {
            try {
                this.setter.invoke(aEntity, aValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }
    }

    static class FieldAccessor<T>
    implements Accessor<T> {
        private Field field;

        public FieldAccessor(Field aField) {
            this.field = aField;
            this.field.setAccessible(true);
        }

        @Override
        public T get(Object aEntity) {
            try {
                Object value = this.field.get(aEntity);
                return (T)value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void set(Object aEntity, T aValue) {
            try {
                this.field.set(aEntity, aValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Field getField() {
            return this.field;
        }
    }

    static interface Accessor<T> {
        public void set(Object var1, T var2);

        public T get(Object var1);
    }
}

