/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtils {
    public static Class wrapIfNeeded(Class aClass) {
        if (aClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (aClass == Byte.TYPE) {
            return Byte.class;
        }
        if (aClass == Character.TYPE) {
            return Character.class;
        }
        if (aClass == Short.TYPE) {
            return Short.class;
        }
        if (aClass == Integer.TYPE) {
            return Integer.class;
        }
        if (aClass == Long.TYPE) {
            return Long.class;
        }
        if (aClass == Float.TYPE) {
            return Float.class;
        }
        if (aClass == Double.TYPE) {
            return Double.class;
        }
        if (aClass == Void.TYPE) {
            return Void.class;
        }
        return aClass;
    }

    public static List<Method> getAllMethods(Class aClass, Class ... aExcludedClasses) {
        if (aClass.isInterface()) {
            throw new IllegalArgumentException(aClass.getName() + " is not an interface.");
        }
        HashMap<String, Method> found = new HashMap<String, Method>();
        ReflectionUtils.getAllMethods(aClass, found, Arrays.asList(aExcludedClasses));
        return new ArrayList<Method>(found.values());
    }

    private static void getAllMethods(Class aClass, Map<String, Method> aFound, List<Class> aExcludedClasses) {
        List<Method> declared = Arrays.asList(aClass.getDeclaredMethods());
        for (Method method : declared) {
            Method superMethod = aFound.get(method.getName());
            if (superMethod == null) {
                aFound.put(method.getName(), method);
                continue;
            }
            if (Arrays.equals(superMethod.getParameterTypes(), method.getParameterTypes())) continue;
            aFound.put(method.getName(), method);
        }
        Class superClass = aClass.getSuperclass();
        if (superClass != null && !aExcludedClasses.contains(superClass)) {
            ReflectionUtils.getAllMethods(superClass, aFound, aExcludedClasses);
        }
    }

    public static List<Field> getAllFields(Class aClass, Class ... aExcludedClasses) {
        if (aClass.isInterface()) {
            throw new IllegalArgumentException(aClass.getName() + " is an interface.");
        }
        ArrayList<Field> found = new ArrayList<Field>();
        ReflectionUtils.getAllFields(aClass, found, Arrays.asList(aExcludedClasses));
        return found;
    }

    private static void getAllFields(Class aClass, List<Field> aFound, List<Class> aExcludedClasses) {
        List<Field> declared = Arrays.asList(aClass.getDeclaredFields());
        for (Field field : declared) {
            aFound.add(field);
        }
        Class superClass = aClass.getSuperclass();
        if (superClass != null && !aExcludedClasses.contains(superClass)) {
            ReflectionUtils.getAllFields(superClass, aFound, aExcludedClasses);
        }
    }
}

