/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.wamblee.io.FileResource;

public class XslTransformer {
    private TransformerFactory factory = TransformerFactory.newInstance();

    public XslTransformer(URIResolver aResolver) {
        this.factory.setURIResolver(aResolver);
    }

    public XslTransformer() {
    }

    public Source resolve(String aXslt) throws TransformerException {
        URIResolver resolver = this.factory.getURIResolver();
        if (resolver == null) {
            if (new File(aXslt).canRead()) {
                try {
                    return new StreamSource(new FileResource(new File(aXslt)).getInputStream());
                }
                catch (IOException e) {
                    throw new TransformerException(e.getMessage(), e);
                }
            }
            throw new TransformerException("Cannot read '" + aXslt + "'");
        }
        return resolver.resolve(aXslt, "");
    }

    public Document transform(Document aDocument, Source aXslt) throws IOException, TransformerException {
        DOMSource source = new DOMSource(aDocument);
        DOMResult result = new DOMResult();
        this.transform(source, result, aXslt);
        return (Document)result.getNode();
    }

    public Document transform(byte[] aDocument, Source aXslt) throws IOException, TransformerException {
        StreamSource source = new StreamSource(new ByteArrayInputStream(aDocument));
        DOMResult result = new DOMResult();
        this.transform(source, result, aXslt);
        return (Document)result.getNode();
    }

    public String textTransform(byte[] aDocument, Source aXslt) throws IOException, TransformerException {
        StreamSource source = new StreamSource(new ByteArrayInputStream(aDocument));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        this.transform(source, result, aXslt);
        return new String(os.toByteArray());
    }

    public void transform(Source aSource, Result aResult, Source aXslt) throws IOException, TransformerException {
        try {
            Transformer transformer = this.factory.newTransformer(aXslt);
            transformer.transform(aSource, aResult);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException("Configuration problem of XSLT transformation", e);
        }
    }
}

