/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package org.wamblee.ioc;

/**
 * Exception thrown by the BeanFactory if an object could not be found.
 * 
 * @author Erik Brakkee
 */
public class BeanFactoryException extends RuntimeException {
    static final long serialVersionUID = -1215992188624874902L;

    /**
     * Constructs the exception.
     * 
     * @param aMsg
     *            Message.
     */
    public BeanFactoryException(String aMsg) {
        super(aMsg);
    }

    /**
     * Constructs the exception.
     * 
     * @param aMsg
     *            Message.
     * @param aThrowable
     *            Cause of the exception.
     */
    public BeanFactoryException(String aMsg, Throwable aThrowable) {
        super(aMsg, aThrowable);
    }
}
