/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.persistence;

/**
 * Inmemory detachable that simply returns the object passed in. Typiocally used for testing. 
 * It does nothing at detach. 
 * 
 * @param <T>
 *            Type of the detachable.
 */
public class InMemoryDetachable<T> implements Detachable<T> {

    private T object;

    /**
     * Constructs the detachable.
     * @param aObject
     */
    public InMemoryDetachable(T aObject) {
        object = aObject;
    }

    /*
     * (non-Javadoc)
     * @see org.wamblee.persistence.Detachable#detach()
     */
    public void detach() {
        // No op.
    }

    /*
     * (non-Javadoc)
     * @see org.wamblee.persistence.Detachable#get()
     */
    public T get() {
        return object;
    }

}
