/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.FileFilter;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.wamblee.io.DirectoryMonitor;
import org.wamblee.io.RegexFilenameFilter;
import org.wamblee.io.TestData;

public class DirectoryMonitorTest
extends TestCase {
    private static final String REGEX = "^.*\\.txt$";
    private static final String FILE1 = "file1.txt";
    private TestData data;
    private DirectoryMonitor.Listener listener;
    private DirectoryMonitor monitor;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new TestData((Object)this);
        this.data.clean();
        this.listener = (DirectoryMonitor.Listener)Mockito.mock(DirectoryMonitor.Listener.class);
        this.monitor = new DirectoryMonitor(this.data.getRoot(), (FileFilter)new RegexFilenameFilter(REGEX), this.listener);
    }

    public void testEmptyDir() {
        for (int i = 0; i < 10; ++i) {
            this.monitor.poll();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
        }
    }

    public void testFileCreated() {
        this.data.createFile(FILE1, "hello");
        this.monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this.listener)).fileCreated(this.data.getFile(FILE1));
    }

    public void testFileDeleted() {
        this.data.createFile(FILE1, "hello");
        this.monitor.poll();
        Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this.listener});
        this.data.deleteFile(FILE1);
        this.monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this.listener)).fileDeleted(this.data.getFile(FILE1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    public void testFileChanged() throws InterruptedException {
        this.data.createFile(FILE1, "hello");
        this.monitor.poll();
        Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this.listener});
        Thread.sleep(2000L);
        this.data.deleteFile(FILE1);
        this.data.createFile(FILE1, "bla");
        this.monitor.poll();
        ((DirectoryMonitor.Listener)Mockito.verify((Object)this.listener)).fileChanged(this.data.getFile(FILE1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    public void testFileFilterIsUsed() {
        this.monitor.poll();
        this.data.createFile("file.xml", "hello");
        this.monitor.poll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    public void testDirectoryIsIgnored() {
        this.monitor.poll();
        this.data.createDir(FILE1);
        this.monitor.poll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    public void testExceptionsWIllLeadToRepeatedNotifications() {
        this.monitor.poll();
        this.data.createFile(FILE1, "hello");
        ((DirectoryMonitor.Listener)Mockito.stubVoid((Object)this.listener).toThrow((Throwable)new RuntimeException()).on()).fileCreated(this.data.getFile(FILE1));
        try {
            this.monitor.poll();
        }
        catch (RuntimeException e) {
            Mockito.reset((Object[])new DirectoryMonitor.Listener[]{this.listener});
            this.monitor.poll();
            ((DirectoryMonitor.Listener)Mockito.verify((Object)this.listener)).fileCreated(this.data.getFile(FILE1));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
            return;
        }
        DirectoryMonitorTest.fail();
    }
}

