/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.ioc;

import junit.framework.TestCase;
import org.wamblee.ioc.BeanFactory;
import org.wamblee.ioc.BeanFactoryException;
import org.wamblee.ioc.BeanKernel;
import org.wamblee.ioc.TestBeanFactory;

public class BeanKernelTest
extends TestCase {
    public void testLoadBeanFactoryFromProperties() {
        BeanFactory factory = BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel.properties");
        BeanKernelTest.assertTrue((boolean)(factory instanceof TestBeanFactory));
    }

    public void testNonExistentPropertyFile() {
        try {
            BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel-nonexistent.properties");
        }
        catch (BeanFactoryException e) {
            return;
        }
        BeanKernelTest.fail();
    }

    public void testNonExistentBeanFactory() {
        try {
            BeanKernel.lookupBeanFactory((String)"org/wamblee/general/beankernel-wrong.properties");
        }
        catch (BeanFactoryException e) {
            return;
        }
        BeanKernelTest.fail();
    }

    public void testRetrieveFactory() {
        BeanKernel.overrideBeanFactory((BeanFactory)new TestBeanFactory());
        BeanFactory factory = BeanKernel.getBeanFactory();
        BeanKernelTest.assertNotNull((Object)factory);
        BeanKernelTest.assertEquals((String)"hello", (String)((String)factory.find(String.class)));
    }
}

