/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import javax.persistence.EntityManager;
import javax.persistence.Id;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.persistence.JpaDetachable;

public class JpaDetachableTest {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = (EntityManager)Mockito.mock(EntityManager.class);
    }

    @Test
    public void testDetachAttach() {
        X x = new X();
        x.id = 100;
        JpaDetachable d = new JpaDetachable(this.em, (Object)x);
        TestCase.assertNull((Object)d.getReference());
        d.detach();
        TestCase.assertEquals((Object)100, (Object)d.getReference());
        X x2 = new X();
        x2.id = 100;
        Mockito.when((Object)this.em.find(X.class, (Object)100)).thenReturn((Object)x2);
        X x3 = (X)d.get();
        TestCase.assertSame((Object)x2, (Object)x3);
        ((EntityManager)Mockito.verify((Object)this.em)).find(X.class, (Object)100);
    }

    public class X {
        @Id
        private int id;
    }
}

