/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.wamblee.io.ClassPathResource;
import org.wamblee.io.FileSystemUtils;
import org.wamblee.xml.ClasspathUriResolver;

public class ClasspathUriResolverTest
extends TestCase {
    private URIResolver resolver;

    protected void setUp() throws Exception {
        this.resolver = new ClasspathUriResolver();
    }

    public void testResolveExistingFile() throws TransformerException, IOException {
        Source source = this.resolver.resolve("org/wamblee/xml/reportToHtml.xsl", "");
        ClasspathUriResolverTest.assertTrue((boolean)(source instanceof StreamSource));
        String resolved = FileSystemUtils.read(((StreamSource)source).getInputStream());
        ClassPathResource resource = new ClassPathResource("org/wamblee/xml/reportToHtml.xsl");
        String expected = FileSystemUtils.read(resource.getInputStream());
        ClasspathUriResolverTest.assertEquals((String)expected, (String)resolved);
    }

    public void testResolveNonExistingFile() {
        try {
            this.resolver.resolve("org/wamblee/xml/reportToHtml-nonexisting.xsl", "");
        }
        catch (TransformerException e) {
            return;
        }
        ClasspathUriResolverTest.fail();
    }
}

