/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.classloading;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassLoaderUtils {
    private static final String JAR_SUFFIX = ".jar";

    public static void addJarsInDirectory(File aDirectory) throws IOException {
        System.out.println("directory '" + aDirectory + "'");
        for (File aFile : aDirectory.listFiles()) {
            System.out.println("Considering '" + aFile.getCanonicalPath() + "'");
            if (!aFile.getName().toLowerCase().endsWith(JAR_SUFFIX)) continue;
            System.out.println("Adding '" + aFile.getCanonicalPath() + "' to classpath.");
            ClassLoaderUtils.addFile(aFile);
        }
    }

    public static void addFile(String aFilename) throws IOException {
        File f = new File(aFilename);
        ClassLoaderUtils.addFile(f);
    }

    public static void addFile(File aFile) throws IOException {
        ClassLoaderUtils.addURL(aFile.toURI().toURL());
    }

    public static void addURL(URL aUrl) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, aUrl);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

