/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class ThreadSpecificInvocationHandler<T>
implements InvocationHandler,
Serializable {
    private static Map<Integer, ThreadLocal> STORAGE = ThreadSpecificInvocationHandler.initializeThreadLocal();
    private static AtomicInteger COUNTER = new AtomicInteger();
    private int id = COUNTER.incrementAndGet();
    private Class clazz;

    private static Map<Integer, ThreadLocal> initializeThreadLocal() {
        ConcurrentHashMap<Integer, ThreadLocal> map = new ConcurrentHashMap<Integer, ThreadLocal>();
        return map;
    }

    public ThreadSpecificInvocationHandler(ThreadLocal aSvc, Class aClass) {
        this.clazz = aClass;
        STORAGE.put(this.id, aSvc);
    }

    @Override
    public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
        ThreadLocal local = STORAGE.get(this.id);
        Object actualSvc = local.get();
        if (aMethod.getName().equals("toString") && actualSvc == null) {
            return "Thread-specific proxy for '" + this.clazz.getName() + "' id = " + this.id;
        }
        try {
            return aMethod.invoke(actualSvc, aArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

