/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;

public class DirectoryMonitor {
    private static final Logger LOG = Logger.getLogger(DirectoryMonitor.class.getName());
    private File directory;
    private FileFilter filter;
    private Listener listener;
    private Map<File, Date> contents;

    public DirectoryMonitor(File aDirectory, FileFilter aFilefilter, Listener aListener) {
        this.directory = aDirectory;
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Directory '" + this.directory + "' does not exist");
        }
        this.filter = aFilefilter;
        this.listener = aListener;
        this.contents = new HashMap<File, Date>();
    }

    public void poll() {
        LOG.fine("Polling " + this.directory);
        HashMap<File, Date> newContents = new HashMap<File, Date>();
        File[] files = this.directory.listFiles(this.filter);
        HashSet<File> deletedFiles = new HashSet<File>(this.contents.keySet());
        for (File file : files) {
            if (!file.isFile() || !this.contents.containsKey(file)) continue;
            deletedFiles.remove(file);
        }
        for (File file : deletedFiles) {
            this.listener.fileDeleted(file);
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            if (this.contents.containsKey(file)) {
                Date oldDate = this.contents.get(file);
                if (file.lastModified() != oldDate.getTime()) {
                    this.listener.fileChanged(file);
                }
                newContents.put(file, new Date(file.lastModified()));
                continue;
            }
            this.listener.fileCreated(file);
            newContents.put(file, new Date(file.lastModified()));
        }
        this.contents = newContents;
    }

    public static interface Listener {
        public void fileChanged(File var1);

        public void fileCreated(File var1);

        public void fileDeleted(File var1);
    }
}

