/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleProcess {
    private static final Logger LOG = Logger.getLogger(SimpleProcess.class.getName());
    private File directory;
    private String[] cmd;
    private String stdout;
    private String stderr;

    public SimpleProcess(File aDirectory, String[] aCmd) {
        this.directory = aDirectory;
        this.cmd = Arrays.copyOf(aCmd, aCmd.length);
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public int run() throws IOException {
        return this.runImpl();
    }

    private int runImpl() throws IOException {
        try {
            StringBuffer fullcmd = new StringBuffer();
            for (String part : this.cmd) {
                fullcmd.append(" " + part);
            }
            LOG.fine("Executing '" + fullcmd + "' in directory '" + this.directory + "'");
            Process proc = Runtime.getRuntime().exec(this.cmd, null, this.directory);
            StringWriter myStdout = new StringWriter();
            StringWriter myStderr = new StringWriter();
            Thread stdoutReader = this.readAndLogStream("STDOUT>  ", proc.getInputStream(), myStdout);
            Thread stderrReader = this.readAndLogStream("STDERR>  ", proc.getErrorStream(), myStderr);
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                IOException exception = new IOException("Process was terminated: " + this);
                exception.initCause(e);
                throw exception;
            }
            this.waitForReader(stdoutReader);
            this.waitForReader(stderrReader);
            this.stdout = myStdout.toString();
            this.stderr = myStderr.toString();
            if (proc.exitValue() != 0) {
                LOG.warning("Exit value was non-zero: " + this);
            } else {
                LOG.fine("Process finished");
            }
            return proc.exitValue();
        }
        catch (IOException e) {
            IOException exception = new IOException("Error executing process: " + this);
            exception.initCause(e);
            throw exception;
        }
    }

    private void waitForReader(Thread aReaderThread) {
        try {
            aReaderThread.join();
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, this + ": error waiting for output stream reader of process to finish", e);
        }
    }

    private Thread readAndLogStream(final String aPrefix, final InputStream aStream, final Writer aOutput) {
        Thread inputReader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String str;
                    br = new BufferedReader(new InputStreamReader(aStream));
                    while ((str = br.readLine()) != null) {
                        LOG.fine(aPrefix + str);
                        aOutput.write(str);
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, SimpleProcess.this + ": error reading input stream", e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            LOG.log(Level.WARNING, "Error closing stream " + aPrefix, e);
                        }
                    }
                }
            }
        };
        inputReader.start();
        return inputReader;
    }

    public String toString() {
        StringBuffer fullcmd = new StringBuffer();
        for (String part : this.cmd) {
            fullcmd.append(part + " ");
        }
        return "process(dir = '" + this.directory + "', cmd = '" + fullcmd + "')";
    }
}

