/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.ioc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wamblee.io.ClassPathResource;
import org.wamblee.ioc.BeanFactory;
import org.wamblee.ioc.BeanFactoryException;

public final class BeanKernel {
    private static final Logger LOG = Logger.getLogger(BeanKernel.class.getName());
    private static final String BEAN_KERNEL_PROP_FILE = "org.wamblee.beanfactory.properties";
    private static final String BEAN_FACTORY_CLASS = "org.wamblee.beanfactory.class";
    private static BeanFactory BEAN_FACTORY;

    private BeanKernel() {
    }

    public static void overrideBeanFactory(BeanFactory aOverride) {
        BEAN_FACTORY = aOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactory getBeanFactory() {
        Class<BeanFactory> clazz = BeanFactory.class;
        synchronized (BeanFactory.class) {
            if (BEAN_FACTORY == null) {
                BEAN_FACTORY = BeanKernel.lookupBeanFactory(BEAN_KERNEL_PROP_FILE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN_FACTORY;
        }
    }

    static BeanFactory lookupBeanFactory(String aPropertyFilename) {
        InputStream is;
        ClassPathResource resource = new ClassPathResource(aPropertyFilename);
        try {
            is = resource.getInputStream();
        }
        catch (IOException e) {
            throw new BeanFactoryException("Cannot open resource " + resource, e);
        }
        try {
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty(BEAN_FACTORY_CLASS);
            Class<?> beanFactory = Class.forName(className);
            BeanFactory beanFactory2 = (BeanFactory)beanFactory.newInstance();
            return beanFactory2;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Cannot read from resource " + resource, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error closing resource " + resource, e);
            }
        }
    }
}

