/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import org.wamblee.persistence.Detachable;

public abstract class AbstractDetachable<T, Ref>
implements Detachable<T> {
    private T object;
    private Ref reference;

    protected AbstractDetachable(T aObject) {
        if (aObject == null) {
            throw new IllegalArgumentException("Object '" + aObject + "' is null");
        }
        this.object = aObject;
        this.reference = null;
    }

    @Override
    public void detach() {
        if (this.object == null) {
            return;
        }
        this.reference = this.getReference(this.object);
        if (this.reference == null) {
            throw new IllegalStateException("Object '" + this.object + "' not persisted yet'");
        }
        this.object = null;
    }

    @Override
    public T get() {
        if (this.object == null) {
            this.object = this.load(this.reference);
            this.reference = null;
        }
        return this.object;
    }

    T getObject() {
        return this.object;
    }

    Ref getReference() {
        return this.reference;
    }

    protected abstract T load(Ref var1);

    protected abstract Ref getReference(T var1);
}

