/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.conditions;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a logical or of different boolean conditions.
 * 
 * @author Erik Brakkee
 * 
 */
public class OrCondition<T> implements Condition<T> {
    private List<Condition<T>> conditions;

    /**
     * Constructs the condition.
     * 
     * @param aCondition1
     *            First condition.
     * @param aCondition2
     *            Second condition.
     */
    public OrCondition(Condition<T> aCondition1, Condition<T> aCondition2) {
        conditions = new ArrayList<Condition<T>>();
        conditions.add(aCondition1);
        conditions.add(aCondition2);
    }

    /**
     * Constructs the or condition.
     * 
     * @param aConditions
     *            List of conditions to use in the logical or.
     */
    public OrCondition(List<Condition<T>> aConditions) {
        conditions = aConditions;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.wamblee.crawler.kiss.ProgramMatcher#matches(org.wamblee.crawler.kiss
     * .Program)
     */
    public boolean matches(T aObject) {
        for (Condition<T> condition : conditions) {
            if (condition.matches(aObject)) {
                return true;
            }
        }

        return false;
    }
}
