/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.general;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * Utility for serializating and deserializing objects.
 * 
 * @author Erik Brakkee
 */
public class ObjectSerializationUtils {

    /**
     * Serialize an object to a byte array.
     * 
     * @param aObject
     *            Object ot serialize.
     * @return Byte array.
     * @throws IOException
     */
    public static byte[] serialize(Object aObject) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(aObject);
        os.flush();
        return bos.toByteArray();
    }

    /**
     * Desrializes an object from a byte array.
     * 
     * @param <T>
     *            Type of the object.
     * @param aData
     *            Serialized data.
     * @param aType
     *            Type of the object.
     * @return Object.
     * @throws IOException
     * @throws ClassNotFoundException
     */
    public static <T> T deserialize(byte[] aData, Class<T> aType)
        throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(aData);
        ObjectInputStream os = new ObjectInputStream(bis);
        return (T) os.readObject();
    }
}
