/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.persistence;

import java.io.Serializable;

/**
 * Represents a detachable object. It represent a reference to a persistent
 * object. The object is detachable in that the memory footprint can be reduced
 * by not keeping a reference to the complete java object, but only to its
 * identify in persistent storage. This is typically the primary key in a
 * relational database.
 */
public interface Detachable<T> extends Serializable {
    /**
     * Detaches the object.
     */
    void detach();

    /**
     * Gets the object, attaching it if needed.
     * 
     * @return
     */
    T get();

}
