/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.reflection;

/**
 * Abstraction for accessing fields or properties of an object.
 * 
 * @author Erik Brakkee
 * 
 * @param <T>
 */
public interface Accessor<T> {
    /**
     * Sets the value.
     * 
     * @param aObject
     *            Object.
     * @param aValue
     *            Value.
     */
    void set(Object aObject, T aValue);

    /**
     * Gets the value.
     * 
     * @param aObject
     *            Object
     * @return Value
     */
    T get(Object aObject);

    /**
     * Gets the type of the value.
     * 
     * @return
     */
    Class<T> getType();
}
