/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.IOException;
import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sf.ehcache.CacheException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.wamblee.cache.Cache;
import org.wamblee.cache.CachedObject;
import org.wamblee.cache.EhCache;
import org.wamblee.cache.ForeverCache;
import org.wamblee.cache.ZeroCache;
import org.wamblee.io.InputResource;
import org.wamblee.io.TestResource;
import org.wamblee.test.TimingUtils;

public class CachedObjectTest
extends TestCase {
    private static final String EHCACHE_CONFIG = "ehcache.xml";
    private static final int OBJECT_KEY = 10;
    private CachedObject.Computation<Integer, Integer> computation;
    private int ncomputations;

    private synchronized void incrementComputations() {
        ++this.ncomputations;
    }

    private synchronized int getComputationCount() {
        return this.ncomputations;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.computation = (CachedObject.Computation)Mockito.mock(CachedObject.Computation.class);
        Mockito.when((Object)this.computation.getObject((Serializable)Integer.valueOf(Mockito.anyInt()))).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock aInvocation) throws Throwable {
                CachedObjectTest.this.ncomputations++;
                return CachedObjectTest.this.compute((Integer)aInvocation.getArguments()[0]);
            }
        });
        this.ncomputations = 0;
    }

    private int compute(int aValue) {
        return aValue + 10;
    }

    private CachedObject<Integer, Integer> createCached(Cache<Integer, Integer> aCache) {
        return new CachedObject(aCache, (Serializable)Integer.valueOf(10), this.computation);
    }

    public void testComputation() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.ncomputations);
    }

    public void testInvalidateCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ForeverCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.ncomputations);
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this.ncomputations);
    }

    public void testBehaviorEhCache() throws CacheException, IOException {
        EhCache cache = new EhCache((InputResource)new TestResource(CachedObjectTest.class, EHCACHE_CONFIG), "test");
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)cache);
        CachedObjectTest.assertTrue((cache == cached.getCache() ? 1 : 0) != 0);
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        TimingUtils.sleep(6000);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this.getComputationCount());
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this.getComputationCount());
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)3, (int)this.getComputationCount());
    }

    public void testBehaviorEhCacheDefault() throws CacheException, IOException {
        EhCache cache = new EhCache((InputResource)new TestResource(CachedObjectTest.class, EHCACHE_CONFIG), "undefined");
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)cache);
        CachedObjectTest.assertTrue((cache == cached.getCache() ? 1 : 0) != 0);
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        TimingUtils.sleep(6000);
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this.getComputationCount());
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)2, (int)this.getComputationCount());
    }

    public void testBehaviorForeverCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ForeverCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        for (int ncomp = 2; ncomp <= 100; ++ncomp) {
            value = (Integer)cached.get();
            CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
            CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        }
    }

    public void testBehaviorZeroCache() {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        int value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)1, (int)this.getComputationCount());
        for (int ncomp = 2; ncomp <= 100; ++ncomp) {
            value = (Integer)cached.get();
            CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
            CachedObjectTest.assertEquals((int)ncomp, (int)this.getComputationCount());
        }
        cached.invalidate();
        value = (Integer)cached.get();
        CachedObjectTest.assertEquals((int)this.compute(10), (int)value);
        CachedObjectTest.assertEquals((int)101, (int)this.getComputationCount());
    }

    public void testPreviousValueWhileComputationBeingDone() throws Exception {
        final CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        Mockito.reset((Object[])new CachedObject.Computation[]{this.computation});
        Mockito.when((Object)this.computation.getObject((Serializable)Integer.valueOf(Mockito.anyInt()))).thenReturn((Object)1).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock aInvocation) throws Throwable {
                TimingUtils.sleep(1000);
                return 2;
            }
        }).thenReturn((Object)3);
        CachedObjectTest.assertEquals((int)1, (int)((Integer)cached.get()));
        Thread recompute = new Thread(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((int)2, (int)((Integer)cached.get()));
            }
        });
        recompute.start();
        TimingUtils.sleep(500);
        CachedObjectTest.assertEquals((int)1, (int)((Integer)cached.get()));
        recompute.join();
    }

    public void testNullValueWhenComputationReturnsNull() throws Exception {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        Mockito.reset((Object[])new CachedObject.Computation[]{this.computation});
        Mockito.when((Object)this.computation.getObject((Serializable)Integer.valueOf(Mockito.anyInt()))).thenReturn((Object)1).thenReturn(null).thenReturn((Object)2);
        CachedObjectTest.assertEquals((int)1, (int)((Integer)cached.get()));
        CachedObjectTest.assertNull((Object)cached.get());
        CachedObjectTest.assertEquals((int)2, (int)((Integer)cached.get()));
    }

    public void testPreviousValueWhenComputationThrowsException() throws Exception {
        CachedObject<Integer, Integer> cached = this.createCached((Cache<Integer, Integer>)new ZeroCache());
        Mockito.reset((Object[])new CachedObject.Computation[]{this.computation});
        Mockito.when((Object)this.computation.getObject((Serializable)Integer.valueOf(Mockito.anyInt()))).thenReturn((Object)1).thenThrow(new Throwable[]{new RuntimeException()}).thenReturn((Object)2);
        CachedObjectTest.assertEquals((int)1, (int)((Integer)cached.get()));
        CachedObjectTest.assertEquals((int)1, (int)((Integer)cached.get()));
        CachedObjectTest.assertEquals((int)2, (int)((Integer)cached.get()));
    }
}

