/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.wamblee.cache.ComputedValue;

public class ComputedValueTest
extends TestCase {
    private ComputedValue.Computation<Integer> computation;
    private ComputedValue<Integer> guard;

    protected void setUp() throws Exception {
        this.computation = (ComputedValue.Computation)Mockito.mock(ComputedValue.Computation.class);
    }

    public void testComputeOutOfDate() {
        this.initGuard();
    }

    private void initGuard() {
        this.guard = new ComputedValue((Object)this, this.computation);
        ComputedValueTest.assertNull((Object)this.guard.getCached());
        Mockito.when((Object)this.computation.isOutOfDate()).thenReturn((Object)true);
        Mockito.when((Object)this.computation.compute()).thenReturn((Object)10);
        int value = (Integer)this.guard.get();
        ComputedValueTest.assertEquals((int)10, (int)value);
        ((ComputedValue.Computation)Mockito.verify(this.computation)).compute();
        Mockito.reset((Object[])new ComputedValue.Computation[]{this.computation});
    }

    public void testGetCached() {
        this.initGuard();
        ComputedValueTest.assertEquals((int)10, (int)((Integer)this.guard.getCached()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.computation});
    }

    public void testNoComputationWhenNotOutOfDate() {
        this.initGuard();
        Mockito.when((Object)this.computation.isOutOfDate()).thenReturn((Object)false);
        ComputedValueTest.assertEquals((int)10, (int)((Integer)this.guard.get()));
        ((ComputedValue.Computation)Mockito.verify(this.computation, (VerificationMode)Mockito.never())).compute();
    }

    public void testOnlyOneConcurrentComputation() throws Exception {
        this.initGuard();
        int computeTime = 500;
        Mockito.when((Object)this.computation.isOutOfDate()).thenReturn((Object)true);
        Mockito.when((Object)this.computation.compute()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock aInvocation) throws Throwable {
                Thread.sleep(500L);
                return 100;
            }
        });
        final ArrayList results = new ArrayList();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int res = (Integer)ComputedValueTest.this.guard.get();
                results.add(res);
            }
        };
        Thread t1 = new Thread(task);
        Thread t2 = new Thread(task);
        t1.start();
        Thread.sleep(250L);
        t2.start();
        t1.join();
        t2.join();
        ComputedValueTest.assertEquals((int)2, (int)results.size());
        ComputedValueTest.assertEquals((int)10, (int)((Integer)results.get(0)));
        ComputedValueTest.assertEquals((int)100, (int)((Integer)results.get(1)));
        ((ComputedValue.Computation)Mockito.verify(this.computation, (VerificationMode)Mockito.times((int)2))).isOutOfDate();
    }

    public void testExceptionWhileComputing() {
        this.initGuard();
        Mockito.when((Object)this.computation.isOutOfDate()).thenReturn((Object)true);
        Mockito.when((Object)this.computation.compute()).thenThrow(new Throwable[]{new RuntimeException("xx")});
        try {
            this.guard.get();
            ComputedValueTest.fail();
        }
        catch (RuntimeException e) {
            ComputedValueTest.assertEquals((String)"xx", (String)e.getMessage());
        }
    }

    public void testExceptionWhileCheckingOutOfDate() {
        this.initGuard();
        Mockito.when((Object)this.computation.isOutOfDate()).thenThrow(new Throwable[]{new RuntimeException("xx")});
        try {
            this.guard.get();
            ComputedValueTest.fail();
        }
        catch (RuntimeException e) {
            ComputedValueTest.assertEquals((String)"xx", (String)e.getMessage());
        }
    }
}

