/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wamblee.general.ObjectSerializationUtils;
import org.wamblee.general.SerializableProxyFactory;

public class SerializableProxyFactoryTest {
    private MyInterface intf;

    @Before
    public void setUp() {
        this.intf = (MyInterface)Mockito.mock(MyInterface.class);
    }

    @Test
    public void testProxyWorks() {
        SerializableProxyFactory factory = new SerializableProxyFactory(MyInterface.class, (Object)this.intf);
        MyInterface proxy = (MyInterface)factory.getProxy();
        proxy.doSomething();
        ((MyInterface)Mockito.verify((Object)this.intf)).doSomething();
    }

    @Test
    public void testProxiesAreUnique() {
        SerializableProxyFactory factory1 = new SerializableProxyFactory(MyInterface.class, (Object)this.intf);
        MyInterface proxy1 = (MyInterface)factory1.getProxy();
        MyInterface intf2 = (MyInterface)Mockito.mock(MyInterface.class);
        SerializableProxyFactory factory2 = new SerializableProxyFactory(MyInterface.class, (Object)intf2);
        MyInterface proxy2 = (MyInterface)factory2.getProxy();
        proxy1.doSomething();
        ((MyInterface)Mockito.verify((Object)this.intf, (VerificationMode)Mockito.times((int)1))).doSomething();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.intf});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{intf2});
        Mockito.reset((Object[])new MyInterface[]{this.intf});
        Mockito.reset((Object[])new MyInterface[]{intf2});
        proxy2.doSomething();
        ((MyInterface)Mockito.verify((Object)intf2, (VerificationMode)Mockito.times((int)1))).doSomething();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.intf});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{intf2});
    }

    @Test
    public void testStillWorksAfterSerialization() throws Exception {
        SerializableProxyFactory factory = new SerializableProxyFactory(MyInterface.class, (Object)this.intf);
        MyInterface proxy = (MyInterface)factory.getProxy();
        MyInterface deserialized = (MyInterface)ObjectSerializationUtils.deserialize((byte[])ObjectSerializationUtils.serialize((Object)proxy), MyInterface.class);
        deserialized.doSomething();
        ((MyInterface)Mockito.verify((Object)this.intf)).doSomething();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongServiceType() {
        SerializableProxyFactory factory = new SerializableProxyFactory(MyInterface.class, (Object)"hello");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotAnInterface() {
        SerializableProxyFactory factory = new SerializableProxyFactory(String.class, (Object)"hello");
    }

    public static interface MyInterface {
        public void doSomething();
    }
}

