/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.general.ThreadSpecificProxyFactory;

public class ThreadSpecificProxyFactoryTest {
    private ThreadSpecificProxyFactory<Service> factory;
    private Service proxy;
    private int returnFromThread;

    @Before
    public void setUp() {
        this.factory = new ThreadSpecificProxyFactory(Service.class);
        this.proxy = (Service)this.factory.getProxy();
    }

    @After
    public void tearDown() {
    }

    @Test(expected=NullPointerException.class)
    public void testNoSvcDefined() throws Exception {
        this.proxy.execute(10);
    }

    @Test
    public void testInvokeThroughProxy() throws Exception {
        Service svc = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)svc.execute(Mockito.anyInt())).thenReturn((Object)50);
        this.factory.set((Object)svc);
        Assert.assertEquals((int)50, (int)this.proxy.execute(10));
        ((Service)Mockito.verify((Object)svc)).execute(10);
    }

    @Test
    public void testCreationCallback() throws Exception {
        ThreadSpecificProxyFactory.CreationCallback callback = (ThreadSpecificProxyFactory.CreationCallback)Mockito.mock(ThreadSpecificProxyFactory.CreationCallback.class);
        Service initialService = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)callback.create()).thenReturn((Object)initialService);
        this.factory = new ThreadSpecificProxyFactory(Service.class, callback);
        this.proxy = (Service)this.factory.getProxy();
        Service svc = (Service)this.factory.get();
        Assert.assertSame((Object)initialService, (Object)svc);
        ((ThreadSpecificProxyFactory.CreationCallback)Mockito.verify((Object)callback)).create();
    }

    @Test
    public void testInvokeThroughProxyWithException() throws Exception {
        Service svc = (Service)Mockito.mock(Service.class);
        try {
            Mockito.when((Object)svc.execute(Mockito.anyInt())).thenThrow(new Throwable[]{new RuntimeException("exception thrown")});
            this.factory.set((Object)svc);
            svc.execute(10);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"exception thrown", (String)e.getMessage());
        }
    }

    @Test
    public void testVerifyThreadSpecificUsingTwoThreads() throws Exception {
        Service svc1 = (Service)Mockito.mock(Service.class);
        final Service svc2 = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)svc1.execute(Mockito.anyInt())).thenReturn((Object)10);
        Mockito.when((Object)svc2.execute(Mockito.anyInt())).thenReturn((Object)20);
        this.factory.set((Object)svc1);
        Assert.assertEquals((int)10, (int)svc1.execute(10));
        Thread t = new Thread(){

            @Override
            public void run() {
                ThreadSpecificProxyFactoryTest.this.factory.set((Object)svc2);
                try {
                    ThreadSpecificProxyFactoryTest.this.returnFromThread = ThreadSpecificProxyFactoryTest.this.proxy.execute(100);
                }
                catch (Exception e) {
                    ThreadSpecificProxyFactoryTest.this.returnFromThread = 100000;
                }
            }
        };
        t.start();
        t.join();
        Assert.assertEquals((int)20, (int)this.returnFromThread);
        Assert.assertEquals((int)10, (int)this.proxy.execute(100));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotAnInterface() {
        ThreadSpecificProxyFactory f = new ThreadSpecificProxyFactory(String.class);
    }

    @Test
    public void testProxyToStringWhileUninitialized() {
        String val = this.proxy.toString();
    }

    private static interface Service {
        public int execute(int var1) throws Exception;
    }
}

