/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.wamblee.reflection.Accessor;
import org.wamblee.reflection.AnnotationUtils;
import org.wamblee.reflection.FieldAccessor;
import org.wamblee.reflection.PropertyAccessor;

public class AnnotationUtilsTest {
    @Test
    public void testPublicField() {
        List accessors = AnnotationUtils.analyse(X1.class, MyAnnotation.class);
        TestCase.assertEquals((int)1, (int)accessors.size());
        TestCase.assertTrue((boolean)(accessors.get(0) instanceof FieldAccessor));
        TestCase.assertEquals(Integer.TYPE, (Object)((Accessor)accessors.get(0)).getType());
        X1 obj = new X1();
        TestCase.assertEquals((int)0, (int)obj.x);
        ((Accessor)accessors.get(0)).set((Object)obj, (Object)100);
        TestCase.assertEquals((int)100, (int)obj.x);
    }

    @Test
    public void testPrivateField() {
        List accessors = AnnotationUtils.analyse(X2.class, MyAnnotation.class);
        TestCase.assertEquals((int)1, (int)accessors.size());
        TestCase.assertTrue((boolean)(accessors.get(0) instanceof FieldAccessor));
        X2 obj = new X2();
        TestCase.assertEquals((int)0, (int)obj.x);
        ((Accessor)accessors.get(0)).set((Object)obj, (Object)100);
        TestCase.assertEquals((int)100, (int)obj.x);
    }

    @Test
    public void testPublicProperty() {
        List accessors = AnnotationUtils.analyse(X3.class, MyAnnotation.class);
        TestCase.assertEquals((int)1, (int)accessors.size());
        TestCase.assertTrue((boolean)(accessors.get(0) instanceof PropertyAccessor));
        TestCase.assertEquals(Integer.TYPE, (Object)((Accessor)accessors.get(0)).getType());
        X3 obj = new X3();
        TestCase.assertEquals((int)0, (int)obj.x);
        ((Accessor)accessors.get(0)).set((Object)obj, (Object)100);
        TestCase.assertEquals((int)100, (int)obj.x);
    }

    @Test
    public void testPrivateProperty() {
        List accessors = AnnotationUtils.analyse(X4.class, MyAnnotation.class);
        TestCase.assertEquals((int)1, (int)accessors.size());
        TestCase.assertTrue((boolean)(accessors.get(0) instanceof PropertyAccessor));
        X4 obj = new X4();
        TestCase.assertEquals((int)0, (int)obj.x);
        ((Accessor)accessors.get(0)).set((Object)obj, (Object)100);
        TestCase.assertEquals((int)100, (int)obj.x);
    }

    @Test
    public void testMultipleMatches() {
        List accessors = AnnotationUtils.analyse(X5.class, MyAnnotation.class);
        TestCase.assertEquals((int)2, (int)accessors.size());
        X5 obj = new X5();
        TestCase.assertEquals((int)0, (int)obj.x);
        TestCase.assertEquals((int)0, (int)obj.y);
        for (Accessor accessor : accessors) {
            accessor.set((Object)obj, (Object)100);
        }
        TestCase.assertEquals((int)100, (int)obj.x);
        TestCase.assertEquals((int)100, (int)obj.y);
    }

    public static class X5 {
        private int x;
        @MyAnnotation
        private int y;

        private void setX(int aX) {
            this.x = aX;
        }

        @MyAnnotation
        private int getX() {
            return this.x;
        }
    }

    public static class X4 {
        private int x;

        private void setX(int aX) {
            this.x = aX;
        }

        @MyAnnotation
        private int getX() {
            return this.x;
        }
    }

    public static class X3 {
        private int x;

        public void setX(int aX) {
            this.x = aX;
        }

        @MyAnnotation
        public int getX() {
            return this.x;
        }
    }

    public static class X2 {
        @MyAnnotation
        private int x;
    }

    public static class X1 {
        @MyAnnotation
        public int x;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface MyAnnotation {
    }
}

